#!/usr/bin/python

# XBL Status -- a friends list for Xbox Live
# Copyright (c) 2008 Chris Hollenbeck
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import ConfigParser
from ConfigParser import NoOptionError
import os
import os.path
import re
#import threading
import time
import urllib2
import sys

from LiveError import LiveError
from LiveConnect import LiveConnect
from LiveFriend import LiveFriend

# Default username and password
# There is no need to edit these in this version.  Use the Edit->Preferences
# menu item instead.
LIVE_LOGIN = "user@example.org"
LIVE_PASSWD = "password"

# Default file locations
SETTINGS_DIR = os.path.expanduser("~/.xblstatus/")
CONFIG_PATH = os.path.join(SETTINGS_DIR, "xblstatus.config")

class XBLStatus:
    def __init__(self, xbl, config_parser):
        self.xbLive = xbl
        self.configParser = config_parser
        try:
            self.xbLive.connect()
        except LiveError, e:
            # TODO: add in error handling in LiveConnect to throw LiveErrors
            print "Error message while connecting:", e.message
 
    def refreshFriends(self):
        try:
            self.xbLive.refresh()
        except LiveError, e:
            print "Error message while refreshing:", e.message
#            self.showErrorDialog(e, "Refresh Error")
            
            # FIXME: finish this section.  need to possibly
            # stop the timer and clean up and disconnect here??
            
            return
        
if __name__ == "__main__":
#    print sys.argv[1]
    if sys.argv[1]!="":
        SETTINGS_DIR = sys.argv[1]
        CONFIG_PATH = os.path.join(SETTINGS_DIR, "xblaccept.config")

    # The parser is used to load and save the config file
    config_parser = ConfigParser.SafeConfigParser()

    # Verify that the settings directory has been created
    if os.path.exists(SETTINGS_DIR) == False:
        # create the directory
        os.mkdir(SETTINGS_DIR)
    elif os.path.exists(CONFIG_PATH) == True:
        # load the saved configuration
        try:
            config_parser.readfp(open(CONFIG_PATH))
            auth_items = config_parser.items("auth")
            pref_items = config_parser.items("prefs")
        
            LIVE_LOGIN = config_parser.get("auth", "login")
            LIVE_PASSWD = config_parser.get("auth", "password")

        except NoOptionError, e:
            print "Configuration item missing. Error message follows:"
            print e.message
            print "Default preferences will be used instead."

    # Create the initial connection
    # Note that all parameters are required

#    print "connecting: ",LIVE_LOGIN,LIVE_PASSWD,SETTINGS_DIR
    xbLive = LiveConnect(LIVE_LOGIN, LIVE_PASSWD, SETTINGS_DIR)

    xblstatus = XBLStatus(xbLive, config_parser)

    while 1==1:
        time.sleep(60)
#        print "refreshing"
        xblstatus.refreshFriends()
        
